import pandas as pd
df = pd.read_csv(r"results\summary.csv")
pivot = "pivot_n0" if "pivot_n0" in df.columns else ("n0" if "n0" in df.columns else None)
rmse  = "RMSE" if "RMSE" in df.columns else None
parts=[]
for row in df.itertuples(index=False):
    seg=[f"{row.dataset}: R2={row.R2:.3f}"]
    if rmse:  seg.append(f"RMSE={getattr(row, rmse):.3f}")
    if pivot: seg.append(f"n0={getattr(row, pivot):.3f}")
    seg.append(f"k={row.k:.3f}")
    parts.append(", ".join(seg))
print("; ".join(parts))
